#!/usr/bin/python
# -*- coding: utf-8 -*-
# @version        : 1.0
# @Create Time    : 2021/10/18 22:19
# @File           : chathistory.py
# @IDE            : PyCharm
# @desc           : 查询参数-类依赖项

"""
类依赖项-官方文档：https://fastapi.tiangolo.com/zh/tutorial/dependencies/classes-as-dependencies/
"""
from fastapi import Depends, Query
from dbgpt.app.apps.core.dependencies import Paging, QueryParams


class ChatHistoryParams(QueryParams):
    """
    列表分页
    """

    def __init__(
            self,
            conv_uid: str | None = Query(None, title="会话ID"),
            message_medias: str | None = Query(None, title="聊天历史资源数据"),
            params: Paging = Depends()
    ):
        super().__init__(params)
        self.conv_uid = conv_uid
        self.message_medias = ("like", message_medias)

