#!/usr/bin/python
# -*- coding: utf-8 -*-
# @version        : 1.0
# @Create Time    : 2021/10/18 22:19
# @File           : user.py
# @IDE            : PyCharm
# @desc           : pydantic 模型，用于数据库序列化操作
from datetime import datetime

from pydantic import BaseModel, ConfigDict, field_validator
from pydantic_core.core_schema import FieldValidationInfo


class SensitiveSchemas(BaseModel):
    word_name: str | None = ""
    is_delete: int | None = 0
    create_datetime: datetime | None = None
    update_datetime: datetime | None = None
    delete_datetime: datetime | None = None

class SensitiveInDic(SensitiveSchemas):
    model_config = ConfigDict(from_attributes=True)

    id :int
    word_name: str | None = ""

class SensitiveIn(SensitiveSchemas):
    """
    创建敏感词
    """
    word_name: str | None = ""

class SensitiveOut(SensitiveSchemas):
    word_name: str | None = ""
    is_delete: int | None = 0
    create_datetime: datetime | None = None
    update_datetime: datetime | None = None
    delete_datetime: datetime | None = None

class SensitiveUpdate(SensitiveSchemas):
    """
    更新敏感词信息
    """
    word_name: str | None = ""
