#!/usr/bin/python
# -*- coding: utf-8 -*-
# @version        : 1.0
# @Create Time    : 2023/5/6 9:29
# @File           : task.py
# @IDE            : PyCharm
# @desc           : 任务基础类

import re
import pymysql
from dbgpt.util.logger import logger
from dbgpt._private.config import Config

class DBGetter:

    def __init__(self):
        self.mysql_cursor = None
        self.mysql_conn = None

    def conn_mysql(self) -> None:
        """
        连接系统中配置的 mysql 数据库
        """
        CFG = Config()
        try:
            username = CFG.LOCAL_DB_USER
            password = CFG.LOCAL_DB_PASSWORD
            host = CFG.LOCAL_DB_HOST
            port = CFG.LOCAL_DB_PORT
            database = CFG.LOCAL_DB_NAME

            self.mysql_conn = pymysql.connect(
                host=host,
                port=port,
                user=username,
                password=password,
                database=database
            )
            self.mysql_cursor = self.mysql_conn.cursor()
        except pymysql.err.OperationalError as e:
            logger.error(f"数据库连接失败，{e}")
            raise ValueError("数据库连接失败！")
        except AttributeError as e:
            logger.error(f"数据库链接解析失败，{e}")
            raise ValueError("数据库链接解析失败！")

    def close_mysql(self) -> None:
        """
        关闭 mysql 链接
        """
        try:
            self.mysql_cursor.close()
            self.mysql_conn.close()
        except AttributeError as e:
            logger.error(f"未连接数据库，无需关闭！，{e}")
            raise ValueError("未连接数据库，无需关闭！")


if __name__ == '__main__':
    t = DBGetter()
    t.conn_mysql()
    t.close_mysql()
