#!/usr/bin/python
# -*- coding: utf-8 -*-
# @version        : 1.0
# @Create Time    : 2021/10/18 22:19
# @File           : user.py
# @IDE            : PyCharm
# @desc           : 查询参数-类依赖项

"""
类依赖项-官方文档：https://fastapi.tiangolo.com/zh/tutorial/dependencies/classes-as-dependencies/
"""
from fastapi import Depends, Query
from dbgpt.app.apps.core.dependencies import Paging, QueryParams


class SimilarParams(QueryParams):
    """
    列表分页
    """

    def __init__(
            self,
            word_name: str | None = Query(None, title="词条"),
            similar_name: str | None = Query(None, title="近义词"),
            params: Paging = Depends()
    ):
        super().__init__(params)
        self.word_name = ("like", word_name)
        self.similar_name = ("like", similar_name)

