#!/usr/bin/python
# -*- coding: utf-8 -*-
# @version        : 1.0
# @Create Time    : 2022/2/24 10:21 
# @File           : crud.py
# @IDE            : PyCharm
# @desc           : 增删改查

from typing import Any
from redis.asyncio import Redis
from fastapi import UploadFile
from sqlalchemy.exc import StatementError
from sqlalchemy.orm import joinedload, aliased
from sqlalchemy.orm.strategy_options import _AbstractLoad, contains_eager
from dbgpt.app.apps.core.exception import CustomException
from fastapi.encoders import jsonable_encoder
from sqlalchemy import select, false, and_, update
from dbgpt.app.apps.core.crud import DalBase
from sqlalchemy.ext.asyncio import AsyncSession
from dbgpt.app.apps.core.validator import vali_telephone
# from dbgpt.app.apps.utils.file.aliyun_oss import AliyunOSS, BucketConf
from dbgpt.app.apps.utils.excel.import_manage import ImportManage, FieldType
from dbgpt.app.apps.utils.excel.write_xlsx import WriteXlsx
# from dbgpt.app.apps.utils.send_email import EmailSender
# from dbgpt.app.apps.utils.sms.reset_passwd import ResetPasswordSMS
from dbgpt.app.apps.utils.tools import test_password

from . import models, schemas
from .params.similar import SimilarParams
from .schemas.similar import SimilarSchemas,SimilarIn,SimilarUpdate
from .schemas.sensitive import SensitiveIn,SensitiveUpdate
from .models import sensitive

from dbgpt.app.apps.config import settings
from dbgpt.app.apps.utils.excel.excel_manage import ExcelManage
from dbgpt.app.apps.system import crud as vadmin_system_crud
# from dbgpt.app.apps.vadmin.help import models as vadmin_help_models
import copy
from dbgpt.app.apps.utils import status
from datetime import datetime
from typing import List

class SimilarDal(DalBase):

    def __init__(self, db: AsyncSession):
        super(SimilarDal, self).__init__()
        self.db = db
        self.model = models.similar.VadminWordSimilar
        self.schema = schemas.similar.SimilarInDic

    async def get_similar_byid(self, qid):
        """
        根据ID查询,近义词
        """
        sql1 = select(models.similar.VadminWordSimilar).where(models.similar.VadminWordSimilar.id == qid)
        queryset1 = await self.db.scalars(sql1)
        similar1 = queryset1.unique().first()
        if similar1 is None:
            print('similar1 is None')
        else:
            print(f"编号：{similar1.id} 词条：{similar1.word_name} 近义词：{similar1.similar_name} ")

    async def update_similars(self, ids: [], data: SimilarUpdate):
        await self.db.execute(
            update(self.model).where(self.model.id.in_(ids)).values(
                update_datetime=datetime.now().strftime("%Y-%m-%d %H:%M:%S"),
                word_name=data.word_name,
                similar_name=data.similar_name
            )
        )

    async def create_data(
            self,
            data: SimilarSchemas,
            v_options: list[_AbstractLoad] = None,
            v_return_obj: bool = False,
            v_schema: Any = None
    ) -> Any:
        """
        创建近义词
        :param data:
        :param v_options:
        :param v_return_obj:
        :param v_schema:
        :return:
        """
        if data is None:
            raise CustomException("data is None！", code=status.HTTP_ERROR)

        unique = await self.get_data(word_name=data.word_name, v_return_none=True)
        if unique:
            raise CustomException("词条已存在！", code=status.HTTP_ERROR)

        obj = self.model()
        obj.word_name = data.word_name
        obj.similar_name = data.similar_name

        await self.flush(obj)
        return await self.out_dict(obj, v_options, v_return_obj, v_schema)

class SensitiveDal(DalBase):

    def __init__(self, db: AsyncSession):
        super(SensitiveDal, self).__init__()
        self.db = db
        self.model = models.sensitive.VadminWordSensitive
        self.schema = schemas.sensitive.SensitiveInDic

    async def create_data(
            self,
            data: SensitiveIn,
            v_options: list[_AbstractLoad] = None,
            v_return_obj: bool = False,
            v_schema: Any = None
    ) -> Any:
        """
        创建敏感词
        :param data:
        :param v_options:
        :param v_return_obj:
        :param v_schema:
        :return:
        """
        if data is None:
            raise CustomException("data is None！", code=status.HTTP_ERROR)

        unique = await self.get_data(word_name=data.word_name, v_return_none=True)
        if unique:
            raise CustomException("词条已存在！", code=status.HTTP_ERROR)

        obj = self.model()
        obj.word_name = data.word_name

        await self.flush(obj)
        return await self.out_dict(obj, v_options, v_return_obj, v_schema)

    async def get_sensitives(self)-> Any:
        sql = select(models.sensitive.VadminWordSensitive).where(models.sensitive.VadminWordSensitive.is_delete == false())
        queryset = await self.db.scalars(sql)
        """
        for row in dataqs:
            print(f"编号：{row.id} 词条：{row.word_name} ")
        """
        return list(queryset.all())

    async def update_sensitives(self, ids: [], data: SensitiveUpdate):
        """
        修改敏感词
        """
        await self.db.execute(
            update(self.model).where(self.model.id.in_(ids)).values(
                update_datetime=datetime.now().strftime("%Y-%m-%d %H:%M:%S"),
                word_name=data.word_name
            )
        )


