#!/usr/bin/python
# -*- coding: utf-8 -*-
# @version        : 1.0
# @Create Time    : 2022/7/7 13:41
# @File           : chathistory.py
# @IDE            : PyCharm
# @desc           : 聊天历史资源模型

from datetime import datetime
from sqlalchemy.orm import relationship, Mapped, mapped_column
from sqlalchemy import Column, DateTime, Integer, String, Text, func
from dbgpt.app.apps.db.db_base import BaseModel


class VadminChatHistory(BaseModel):
    __tablename__ = "vadmin_chat_history"
    __table_args__ = ({'comment': '聊天历史资源表'})

    conv_uid: Mapped[str] = mapped_column(String(255), index=True, unique=False, nullable=False, comment="会话ID")
    message_medias: Mapped[str] = mapped_column(Text(length=2 ** 31 - 1), index=True, nullable=False, comment="聊天历史资源数据")