#!/usr/bin/python
# -*- coding: utf-8 -*-

from sqlalchemy.orm import Mapped, mapped_column
from dbgpt.app.apps.db.db_base import BaseModel
from sqlalchemy import String, ForeignKey, Integer, JSON


class VadminMedia(BaseModel):
    __tablename__ = "vadmin_media"
    __table_args__ = ({'comment': '资源表'})
    file_name: Mapped[str] = mapped_column(String(500), index=True, nullable=False, comment="文件原名称")
    type: Mapped[int] = mapped_column(Integer, nullable=False, comment="类型")
    group_id: Mapped[int] = mapped_column(Integer, nullable=True, comment="关联分组id")
    key_word: Mapped[str] = mapped_column(String(500), comment="关键词")
    local_path: Mapped[str] = mapped_column(String(500), nullable=False, comment="绝对路径")
    remote_path: Mapped[str] = mapped_column(String(500), nullable=False, comment="访问路径")
    is_delete: Mapped[int] = mapped_column(Integer, comment="是否删除", default=0)


class VadminGroup(BaseModel):
    __tablename__ = "vadmin_group"
    __table_args__ = ({'comment': '分组表'})
    name: Mapped[str] = mapped_column(String(500), index=True, nullable=False, comment="组名称")
    type: Mapped[int] = mapped_column(Integer, nullable=False, comment="类型")
    is_delete: Mapped[int] = mapped_column(Integer, comment="是否删除", default=0)


class VadminQuestion(BaseModel):
    __tablename__ = "vadmin_question"
    __table_args__ = ({'comment': '问答对表'})
    title: Mapped[str] = mapped_column(String(500), index=True, nullable=False, comment="问题标题")
    key_word: Mapped[str] = mapped_column(String(255), comment="关键词")
    answer: Mapped[str] = mapped_column(String(2000), comment="标准答案")
    group_id: Mapped[int] = mapped_column(Integer, nullable=True, comment="关联分组id")
    is_delete: Mapped[int] = mapped_column(Integer, comment="是否删除", default=0)


class VadminCorrelation(BaseModel):
    __tablename__ = "knowledge_space"
    __table_args__ = ({'comment': '知识库表'})
    name: Mapped[str] = mapped_column(String(100), comment="知识库名称")
    image_group: Mapped[str] = mapped_column(JSON, nullable=True, comment="图片分组")
    video_group: Mapped[str] = mapped_column(JSON, nullable=True, comment="视频分组")
    question_group: Mapped[str] = mapped_column(JSON, nullable=True, comment="问答对分组")