#!/usr/bin/python
# -*- coding: utf-8 -*-
# @version        : 1.0
# @Create Time    : 2022/2/24 10:21 
# @File           : crud.py
# @IDE            : PyCharm
# @desc           : 增删改查

from typing import Any
from redis.asyncio import Redis
from fastapi import UploadFile
from sqlalchemy.exc import StatementError
from sqlalchemy.orm import joinedload, aliased
from sqlalchemy.orm.strategy_options import _AbstractLoad, contains_eager
from dbgpt.app.apps.core.exception import CustomException
from fastapi.encoders import jsonable_encoder
from sqlalchemy import select, false, and_, update
from dbgpt.app.apps.core.crud import DalBase
from sqlalchemy.ext.asyncio import AsyncSession
from dbgpt.app.apps.core.validator import vali_telephone
# from dbgpt.app.apps.utils.file.aliyun_oss import AliyunOSS, BucketConf
from dbgpt.app.apps.utils.excel.import_manage import ImportManage, FieldType
from dbgpt.app.apps.utils.excel.write_xlsx import WriteXlsx
# from dbgpt.app.apps.utils.send_email import EmailSender
# from dbgpt.app.apps.utils.sms.reset_passwd import ResetPasswordSMS
from dbgpt.app.apps.utils.tools import test_password

from .models.chathistory import VadminChatHistory
from .params.chathistory import ChatHistoryParams
from .schemas.chathistory import ChatHistorySchemas, ChatHistoryIn, ChatHistoryUpdate, ChatHistoryInDic

from dbgpt.app.apps.config import settings
from dbgpt.app.apps.utils.excel.excel_manage import ExcelManage
from dbgpt.app.apps.system import crud as vadmin_system_crud

import copy
from dbgpt.app.apps.utils import status
from datetime import datetime
from typing import List


class ChatHistoryDal(DalBase):

    def __init__(self, db: AsyncSession):
        super(ChatHistoryDal, self).__init__()
        self.db = db
        self.model = VadminChatHistory
        self.schema = ChatHistoryInDic

    async def create_data(
            self,
            data: ChatHistorySchemas,
            v_options: list[_AbstractLoad] = None,
            v_return_obj: bool = False,
            v_schema: Any = None
    ) -> Any:
        """
        创建
        :param data:
        :param v_options:
        :param v_return_obj:
        :param v_schema:
        :return:
        """
        if data is None:
            raise CustomException("data is None！", code=status.HTTP_ERROR)

        """
        unique = await self.get_data(conv_uid=data.conv_uid, v_return_none=True)
        if unique:
            raise CustomException("会话已存在！", code=status.HTTP_ERROR)
        """

        print(f"-------打印会话ID----->:{data.conv_uid}")
        obj = self.model()
        obj.conv_uid = data.conv_uid
        obj.message_medias = data.message_medias

        await self.flush(obj)
        return await self.out_dict(obj, v_options, v_return_obj, v_schema)
