#!/usr/bin/python
# -*- coding: utf-8 -*-
# @version        : 1.0
# @Create Time    : 2021/10/18 22:19
# @File           : chathistory.py
# @IDE            : PyCharm
# @desc           : pydantic 模型，用于数据库序列化操作
from datetime import datetime

from pydantic import BaseModel, ConfigDict, field_validator
from pydantic_core.core_schema import FieldValidationInfo


class ChatHistorySchemas(BaseModel):
    conv_uid: str | None = ""
    message_medias: str | None = ""
    is_delete: int | None = 0
    create_datetime: datetime | None = None
    update_datetime: datetime | None = None
    delete_datetime: datetime | None = None


class ChatHistoryInDic(ChatHistorySchemas):
    model_config = ConfigDict(from_attributes=True)
    id: int
    conv_uid: str | None = ""
    message_medias: str | None = ""


class ChatHistoryIn(ChatHistorySchemas):
    """
    创建
    """
    conv_uid: str | None = ""
    message_medias: str | None = ""


class ChatHistoryOut(ChatHistorySchemas):
    conv_uid: str | None = ""
    message_medias: str | None = ""
    is_delete: int | None = 0
    create_datetime: datetime | None = None
    update_datetime: datetime | None = None
    delete_datetime: datetime | None = None


class ChatHistoryUpdate(ChatHistorySchemas):
    """
    更新
    """
    conv_uid: str | None = ""
    message_medias: str | None = ""
