from redis.asyncio import Redis
from fastapi import APIRouter, Depends, Body, UploadFile, Request

from dbgpt.app.apps.utils.response import SuccessResponse, ErrorResponse

from dbgpt.app.apps.vadmin.auth.utils.current import AllUserAuth, FullAdminAuth, OpenAuth
from dbgpt.app.apps.vadmin.auth.utils.validation.auth import Auth

from . import schemas, crud, models
from dbgpt.app.apps.vadmin.chathistory.models.chathistory import VadminChatHistory
from dbgpt.app.apps.vadmin.chathistory.params.chathistory import ChatHistoryParams
from dbgpt.app.apps.vadmin.chathistory.schemas.chathistory import ChatHistorySchemas, ChatHistoryIn,ChatHistoryUpdate
from dbgpt.app.apps.vadmin.chathistory import crud
from fastapi.encoders import jsonable_encoder

from ...core.dependencies import IdList

router = APIRouter()


###########################################################
#    聊天记录资源管理
###########################################################
@router.get("/get_chat_history", summary="获取聊天历史资源列表")
async def get_chat_history(para: ChatHistoryParams = Depends(), auth: Auth = Depends(OpenAuth())):
    print(f"---打印输入参数--->:{para.dict()}")
    v_schema = schemas.chathistory.ChatHistoryInDic
    datas, count = await crud.ChatHistoryDal(auth.db).get_datas(
        **para.dict(),
        v_schema=v_schema,
        v_return_count=True
    )
    return SuccessResponse(datas, count=count)

@router.post("/create_chat_history", summary="创建聊天历史资源")
async def create_chat_history(qdata: Request, auth: Auth = Depends(OpenAuth())):
    if qdata is None:
        print('create_chat_history is None')
    else:
        print(f"req会话ID：{qdata.query_params['conv_uid']} req会话历史资源：{qdata.query_params['message_medias']} ")

    simi_data = ChatHistorySchemas()
    simi_data.conv_uid = qdata.query_params['conv_uid']
    simi_data.message_medias = qdata.query_params['message_medias']
    return SuccessResponse(await crud.ChatHistoryDal(auth.db).create_data(data=simi_data))