#!/usr/bin/python
# -*- coding: utf-8 -*-
# @version        : 1.0
# @Create Time    : 2021/10/18 22:19
# @File           : user.py
# @IDE            : PyCharm
# @desc           : pydantic 模型，用于数据库序列化操作
from datetime import datetime

from pydantic import BaseModel, ConfigDict, field_validator
from pydantic_core.core_schema import FieldValidationInfo


class SimilarSchemas(BaseModel):
    word_name: str | None = ""
    similar_name: str | None = ""
    is_delete: int | None = 0
    create_datetime: datetime | None = None
    update_datetime: datetime | None = None
    delete_datetime: datetime | None = None

class SimilarInDic(SimilarSchemas):
    model_config = ConfigDict(from_attributes=True)
    """
    创建近义词
    """
    id :int
    word_name: str
    similar_name: str | None = ""

class SimilarIn(SimilarSchemas):
    """
    创建近义词
    """
    word_name: str | None = ""
    similar_name: str | None = ""
    is_delete: int | None = 0
    create_datetime: datetime | None = None
    update_datetime: datetime | None = None
    delete_datetime: datetime | None = None

class SimilarOut(SimilarSchemas):
    word_name: str | None = ""
    similar_name: str | None = ""
    is_delete: int | None = 0
    create_datetime: datetime | None = None
    update_datetime: datetime | None = None
    delete_datetime: datetime | None = None

class SimilarUpdate(SimilarSchemas):
    """
    更新近义词信息
    """
    word_name: str | None = ""
    similar_name: str | None = ""
