from redis.asyncio import Redis
from fastapi import APIRouter, Depends, Body, UploadFile, Request

from dbgpt.app.apps.utils.response import SuccessResponse, ErrorResponse

from dbgpt.app.apps.vadmin.auth.utils.current import AllUserAuth, FullAdminAuth, OpenAuth
from dbgpt.app.apps.vadmin.auth.utils.validation.auth import Auth

from . import schemas, crud, models
from dbgpt.app.apps.vadmin.word.models.similar import VadminWordSimilar
from dbgpt.app.apps.vadmin.word.models.sensitive import VadminWordSensitive
from dbgpt.app.apps.vadmin.word.params.similar import SimilarParams
from dbgpt.app.apps.vadmin.word.schemas.similar import SimilarSchemas, SimilarIn,SimilarUpdate
from dbgpt.app.apps.vadmin.word.schemas.sensitive import SensitiveSchemas, SensitiveIn,SensitiveUpdate
from dbgpt.app.apps.vadmin.word.params.sensitive import SensitiveParams
from dbgpt.app.apps.vadmin.word import crud
from fastapi.encoders import jsonable_encoder
from dbgpt.app.apps.utils.filter import mydfafiter, mydfafiter_picture, mydfafiter_question, mydfafiter_video
from ...core.dependencies import IdList
from sqlalchemy import BinaryExpression

router = APIRouter()


###########################################################
#    同义词管理
###########################################################
@router.get("/get_similars", summary="获取同义词列表")
async def get_similars(para: SimilarParams = Depends(), auth: Auth = Depends(FullAdminAuth())):
    v_schema = schemas.similar.SimilarInDic
    datas, count = await crud.SimilarDal(auth.db).get_datas(
        **para.dict(),
        v_schema=v_schema,
        v_return_count=True
    )
    return SuccessResponse(datas, count=count)

@router.post("/create_similar", summary="创建同义词")
async def create_similar(qdata: Request, auth: Auth = Depends(FullAdminAuth())):
    if qdata is None:
        print('create_similar is None')
    else:
        print(f"req词条：{qdata.query_params['word_name']} req近义词：{qdata.query_params['similar_name']} ")

    simi_data = SimilarSchemas()
    simi_data.word_name = qdata.query_params['word_name']
    simi_data.similar_name = qdata.query_params['similar_name']
    return SuccessResponse(await crud.SimilarDal(auth.db).create_data(data=simi_data))

@router.post("/delete_similars", summary="根据id删除同义词")
async def delete_similars(ids: IdList = Depends(), auth: Auth = Depends(FullAdminAuth())):
    await crud.SimilarDal(auth.db).delete_datas(ids=ids.ids, v_soft=True)
    return SuccessResponse("删除成功")

@router.post("/update_similar_byid", summary="根据id修改同义词")
async def update_similar_byid(data: Request, auth: Auth = Depends(FullAdminAuth())):
    if data is None:
        print('SimilarIn is None')
        return ErrorResponse("不能修改当前近义词")
    else:
        print(f"word_id：{data.query_params['id']} req词条：{data.query_params['word_name']} req近义词：{data.query_params['similar_name']} ")

    data_id = data.query_params['id']

    sdata = SimilarUpdate
    sdata.word_name = data.query_params['word_name']
    sdata.similar_name = data.query_params['similar_name']

    similarids = []
    similarids.append(data_id)

    await crud.SimilarDal(auth.db).update_similars(similarids, sdata)
    return SuccessResponse("修改成功")

###########################################################
#    敏感词管理
###########################################################
@router.post("/create_sensitive", summary="创建敏感词")
async def create_sensitive(qdata: Request, auth: Auth = Depends(FullAdminAuth())):
    if qdata is None:
        print('create_sensitive is None')
    else:
        print(f"req词条：{qdata.query_params['word_name']} ")

    Sensit_data = SensitiveSchemas()
    Sensit_data.word_name = qdata.query_params['word_name']

    # 向敏感词字典中新加一条敏感词
    mydfafiter.add(Sensit_data.word_name)

    return SuccessResponse(await crud.SensitiveDal(auth.db).create_data(data=Sensit_data))

@router.get("/get_sensitives", summary="获取敏感词列表")
async def get_sensitives(para: SensitiveParams = Depends(), auth: Auth = Depends(FullAdminAuth())):
    v_schema = schemas.sensitive.SensitiveInDic
    datas, count = await crud.SensitiveDal(auth.db).get_datas(
        **para.dict(),
        v_schema=v_schema,
        v_return_count=True
    )
    return SuccessResponse(datas, count=count)

@router.post("/update_sensitive_byid", summary="根据id修改敏感词")
async def update_sensitive_byid(data: Request, auth: Auth = Depends(FullAdminAuth())):
    if data is None:
        print('SimilarIn is None')
        return ErrorResponse("不能修改当前敏感词")
    else:
        print(f"word_id：{data.query_params['id']} req词条：{data.query_params['word_name']}  ")

    data_id = data.query_params['id']
    sdata = SensitiveUpdate
    sdata.word_name = data.query_params['word_name']

    sensitive_datas = await crud.SensitiveDal(auth.db).get_sensitive_byid(data_id)
    if sensitive_datas != None:
        print(f"------编辑时要删除旧的敏感词------>:{sensitive_datas.word_name}")
        mydfafiter.remove(sensitive_datas.word_name)
        print(f"------编辑时要添加新的敏感词------>:{sdata.word_name}")
        mydfafiter.add(sdata.word_name)

    sensitiveids = []
    sensitiveids.append(data_id)

    await crud.SensitiveDal(auth.db).update_sensitives(sensitiveids, sdata)
    return SuccessResponse("修改成功")

@router.post("/delete_sensitives", summary="根据id删除敏感词")
async def delete_sensitives(ids: IdList = Depends(), auth: Auth = Depends(FullAdminAuth())):
    id_filter: BinaryExpression = VadminWordSensitive.id.in_(ids.ids)
    q_datas, count = await crud.SensitiveDal(auth.db).get_datas(v_where=[id_filter], v_return_count=True)
    for qdata in q_datas:
        mydfafiter.remove(qdata.get('key_word'))

    await crud.SensitiveDal(auth.db).delete_datas(ids=ids.ids, v_soft=True)
    return SuccessResponse("删除成功")