from dbgpt._private.config import Config
from dbgpt.app.scene import AppScenePromptTemplateAdapter, ChatScene
from dbgpt.app.scene.chat_normal.out_parser import NormalChatOutputParser
from dbgpt.core import (
    ChatPromptTemplate,
    HumanPromptTemplate,
    MessagesPlaceholder,
    SystemPromptTemplate,
)

CFG = Config()

PROMPT_SCENE_DEFINE = """A chat between a curious user and an artificial intelligence assistant, who very familiar with database related knowledge. 
The assistant gives helpful, detailed, professional and polite answers to the user's questions. """


_DEFAULT_TEMPLATE_ZH = """ 基于以下给出的已知信息, 准守规范约束，专业、简要回答用户的问题.
规范约束:
     1.如果已知信息包含的链接、表格、代码块等特殊markdown标签格式的信息，确保在答案中包含原文这链接、表格和代码标签，不要丢弃不要修改，如:链接格式:[xxx](xxx), 表格格式:|xxx|xxx|xxx|, 代码格式:```xxx```.
     2.不要在答案中包含图片.
     3.如果无法从提供的内容中获取答案, 请说: "知识库中提供的内容不足以回答此问题" 禁止胡乱编造.
     4.回答的时候最好按照1.2.3.点进行总结, 并以markdwon格式显示.
            已知内容: 
            {context}
            问题:
            {question},请使用和用户相同的语言进行回答..
"""
_DEFAULT_TEMPLATE_EN = """ 基于以下给出的已知信息, 准守规范约束，专业、简要回答用户的问题.
规范约束:
     1.如果已知信息包含的链接、表格、代码块等特殊markdown标签格式的信息，确保在答案中包含原文这链接、表格和代码标签，不要丢弃不要修改，如:链接格式:[xxx](xxx), 表格格式:|xxx|xxx|xxx|, 代码格式:```xxx```.
     2.不要在答案中包含图片.
     3.如果无法从提供的内容中获取答案, 请说: "知识库中提供的内容不足以回答此问题" 禁止胡乱编造.
     4.回答的时候最好按照1.2.3.点进行总结, 并以markdwon格式显示.
            已知内容: 
            {context}
            问题:
            {question},请使用和用户相同的语言进行回答..
"""

_DEFAULT_TEMPLATE = (
    _DEFAULT_TEMPLATE_EN if CFG.LANGUAGE == "en" else _DEFAULT_TEMPLATE_ZH
)

PROMPT_NEED_STREAM_OUT = True
prompt = ChatPromptTemplate(
    messages=[
        SystemPromptTemplate.from_template(_DEFAULT_TEMPLATE),
        MessagesPlaceholder(variable_name="chat_history"),
        HumanPromptTemplate.from_template("{question}"),
    ]
)

prompt_adapter = AppScenePromptTemplateAdapter(
    prompt=prompt,
    template_scene=ChatScene.ChatKnowledge.value(),
    stream_out=PROMPT_NEED_STREAM_OUT,
    output_parser=NormalChatOutputParser(is_stream_out=PROMPT_NEED_STREAM_OUT),
    need_historical_messages=False,
)

CFG.prompt_template_registry.register(
    prompt_adapter, language=CFG.LANGUAGE, is_default=True
)
