#!/usr/bin/python
# -*- coding: utf-8 -*-

from pydantic import BaseModel, ConfigDict, Field
from dbgpt.app.apps.core.data_types import DatetimeStr
from typing import List

class Media(BaseModel):
    file_name: str
    type: int
    group_id: int | None = 0
    key_word: str | None = None
    local_path: str
    remote_path: str


class MediaOut(Media):
    model_config = ConfigDict(from_attributes=True)

    id: int
    create_datetime: DatetimeStr
    update_datetime: DatetimeStr


class Group(BaseModel):
    name: str
    type: int


class GroupOut(Group):
    model_config = ConfigDict(from_attributes=True)

    id: int
    create_datetime: DatetimeStr
    update_datetime: DatetimeStr


class Question(BaseModel):
    title: str | None = None
    key_word: str | None = None
    answer: str | None = None
    group_id: int | None = 0


class QuestionOut(Question):
    model_config = ConfigDict(from_attributes=True)

    id: int
    create_datetime: DatetimeStr
    update_datetime: DatetimeStr


class GroupJson(BaseModel):
    group_id: int
    group_name: str


class Correlation(BaseModel):
    id: int
    image_group: List[GroupJson] | None = None
    video_group: List[GroupJson] | None = None
    question_group: List[GroupJson] | None = None


class CorrelationOut(Correlation):
    model_config = ConfigDict(from_attributes=True)

    id: int
    name: str
