#!/usr/bin/python
# -*- coding: utf-8 -*-


from fastapi import Depends
from dbgpt.app.apps.core.dependencies import Paging, QueryParams


class MediaListParams(QueryParams):
    """
    列表分页
    """

    def __init__(self, group_id: int = None, type: int = None, file_name: str = None, params: Paging = Depends()):
        super().__init__(params)
        self.type = type
        self.group_id = group_id
        self.file_name = ("like", file_name)


class GroupListParams(QueryParams):
    def __init__(self, type: int = None):
        super().__init__()
        self.type = type


class MediaEditParams:
    def __init__(self, ids: list[int] = None, file_name: str = None, group_id: int = None):
        super().__init__()
        self.ids = ids
        self.file_name = file_name
        self.group_id = group_id


class QuestionListParams(QueryParams):
    def __init__(self, group_id: int = None, title: str = None, params: Paging = Depends()):
        super().__init__(params)
        self.group_id = group_id
        self.title = ("like", title)


class QuestionEditParams:
    def __init__(self, ids: list[int] = None, title: str = None, group_id: int = None, key_word: str = None, answer: str = None):
        super().__init__()
        self.ids = ids
        self.title = title
        self.key_word = key_word
        self.answer = answer
        self.group_id = group_id


class CorrelationListParams(QueryParams):
    def __init__(self, name: str = None, params: Paging = Depends()):
        super().__init__(params)
        self.name = ("like", name)