define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    //设置弹窗宽高
    Fast.config.openArea = ['80%', '80%'];

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'cms/special/index' + location.search,
                    add_url: 'cms/special/add',
                    edit_url: 'cms/special/edit',
                    del_url: 'cms/special/del',
                    multi_url: 'cms/special/multi',
                    table: 'cms_special',
                }
            });

            var table = $("#table");

            var columns = [
                {checkbox: true},
                {field: 'id', title: __('Id')},
                {field: 'title', title: __('Title'), operate: 'like'},
                {field: 'flag', title: __('Flag'), searchList: {"hot": __('Hot'), "new": __('New'), "recommend": __('Recommend'), "top": __('Top')}, operate: 'FIND_IN_SET', formatter: Table.api.formatter.label},
                {field: 'label', title: __('Label')},
                {field: 'image', title: __('Image'), operate: false, events: Table.api.events.image, formatter: Table.api.formatter.image},
                {field: 'banner', title: __('Banner'), operate: false, events: Table.api.events.image, formatter: Table.api.formatter.image},
                {
                    field: 'url', title: __('Url'), operate: false, formatter: function (value, row, index) {
                        return '<div class=""><a href="' + row.url + '" class="btn btn-xs btn-default" target="_blank"><i class="fa fa-link"></i></a></div>';
                    }
                },
                {
                    field: 'spiders', title: __('Spiders'), visible: Config.spiderRecord || false, operate: false, formatter: function (value, row, index) {
                        if (!$.isArray(value) || value.length === 0) {
                            return '-';
                        }
                        var html = [];
                        $.each(value, function (i, j) {
                            var color = 'default', title = '暂无来访记录';
                            if (j.status === 'today') {
                                color = 'danger';
                                title = "今天有来访记录";
                            } else if (j.status === 'pass') {
                                color = 'success';
                                title = "最后来访日期：" + j.date;
                            }
                            html.push('<span class="label label-' + color + '" data-toggle="tooltip" data-title="' + j.title + ' ' + title + '">' + j.title.substr(0, 1) + '</span>');
                        });
                        return html.join(" ");
                    }
                },
                {field: 'views', title: __('Views'), operate: 'BETWEEN', sortable: true},
                {
                    field: 'comments', title: __('Comments'), operate: 'BETWEEN', sortable: true, formatter: function (value, row, index) {
                        return '<a href="javascript:" data-url="cms/comment/index?type=special&aid=' + row['id'] + '" title="评论列表" class="dialogit">' + value + '</a>';
                    }
                },
                {field: 'createtime', title: __('Createtime'), operate: 'RANGE', addclass: 'datetimerange', formatter: Table.api.formatter.datetime},
                {field: 'updatetime', title: __('Updatetime'), visible: false, operate: 'RANGE', addclass: 'datetimerange', formatter: Table.api.formatter.datetime},
                {field: 'status', title: __('Status'), searchList: {"normal": __('Normal'), "hidden": __('Hidden')}, formatter: Table.api.formatter.status},
                {field: 'operate', title: __('Operate'), clickToSelect: false, table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
            ];

            //动态主表追加字段
            columns.splice.apply(columns, [-1, 0].concat(Fast.api.getCustomFields(Config.fields, table)));

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'id',
                sortName: 'id',
                fixedColumns: true,
                fixedRightNumber: 1,
                columns: columns
            });

            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        recyclebin: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    'dragsort_url': ''
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: 'cms/special/recyclebin',
                pk: 'id',
                sortName: 'id',
                columns: [
                    [
                        {checkbox: true},
                        {field: 'id', title: __('Id')},
                        {field: 'title', title: __('Title'), formatter: Table.api.formatter.search},
                        {
                            field: 'deletetime',
                            title: __('Deletetime'),
                            operate: 'RANGE',
                            addclass: 'datetimerange',
                            formatter: Table.api.formatter.datetime
                        },
                        {
                            field: 'operate',
                            width: '130px',
                            title: __('Operate'),
                            table: table,
                            events: Table.api.events.operate,
                            buttons: [
                                {
                                    name: 'Restore',
                                    text: __('Restore'),
                                    classname: 'btn btn-xs btn-info btn-ajax btn-restoreit',
                                    icon: 'fa fa-rotate-left',
                                    url: 'cms/special/restore',
                                    refresh: true
                                },
                                {
                                    name: 'Destroy',
                                    text: __('Destroy'),
                                    classname: 'btn btn-xs btn-danger btn-ajax btn-destroyit',
                                    icon: 'fa fa-times',
                                    url: 'cms/special/destroy',
                                    refresh: true
                                }
                            ],
                            formatter: Table.api.formatter.operate
                        }
                    ]
                ]
            });

            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {

                $.validator.config({
                    rules: {
                        diyname: function (element) {
                            if (element.value.toString().match(/^\d+$/)) {
                                return __('Can not be only digital');
                            }
                            if (!element.value.toString().match(/^[a-zA-Z0-9\-_]+$/)) {
                                return __('Please input character or digital');
                            }
                            return $.ajax({
                                url: 'cms/special/check_element_available',
                                type: 'POST',
                                data: {id: $("#special-id").val(), name: element.name, value: element.value},
                                dataType: 'json'
                            });
                        }
                    }
                });


                //获取标题拼音
                var si;
                $(document).on("keyup", "#c-title", function () {
                    var value = $(this).val();
                    if (value != '' && !value.match(/\n/)) {
                        clearTimeout(si);
                        si = setTimeout(function () {
                            Fast.api.ajax({
                                loading: false,
                                url: "cms/ajax/get_title_pinyin",
                                data: {title: value}
                            }, function (data, ret) {
                                $("#c-diyname").val(data.pinyin.substr(0, 100));
                                return false;
                            }, function (data, ret) {
                                return false;
                            });
                        }, 200);
                    }
                });
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
